	% This Matlab script adds pi's to the y-axis tick label elements whenever
	% it is seen appropriate
	% Tapio 27.9.2018
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 2018-09-22
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	yticks = get(gca,'YTickLabel');
	pos = get(gca,'YTick');
	inx1 = find(abs(1-pos)<10^-10);
	inx2 = find(pos == 0);
	inx3 = find(abs(-1-pos)<10^-10);
	l = size(yticks);
	l = l(1);
	for K = 1:l
		if ~isempty(inx1) & K == inx1
			yticks{K}=['\pi'];
		elseif ~isempty(inx2) & (K == inx2)
			yticks{K}=[yticks{K}];
		elseif ~isempty(inx3) & (K == inx3)
			yticks{K}=['-\pi'];
		else
			yticks{K}=[yticks{K} '\pi'];
		end
	end
	set(gca,'YTickLabel',yticks) % set tick labels to updated values
	
